/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.servlet;

import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.ui.bonsai.servlet.Action;
import com.ibm.hwmca.ui.bonsai.servlet.InitAction;
import com.ibm.hwmca.ui.bonsai.servlet.util.UIRefreshManager;
import com.ibm.hwmca.ui.bonsai.servlet.util.UserObject;
import com.ibm.hwmca.ui.bonsai.status.StatusMonitorBean;
import com.ibm.hwmca.ui.bonsai.status.StatusMonitorManager;
import com.ibm.hwmca.ui.bonsai.status.SystemHealthModel;
import com.ibm.psw.wcc.common.WccTitlebar;
import com.ibm.psw.wcl.core.CommandEvent;
import com.ibm.psw.wcl.core.ICommandListener;
import com.ibm.psw.wcl.core.RenderingContext;
import com.ibm.psw.wcl.core.WComponent;
import com.ibm.psw.wcl.core.WPage;
import com.ibm.psw.wcl.core.form.WImageButton;
import com.ibm.psw.wcl.core.layout.WBoxLayout;
import com.ibm.psw.wcl.core.layout.WFramesetLayout;
import com.ibm.psw.wcl.core.markup.WHyperlink;
import com.ibm.psw.wcl.core.markup.WImage;
import com.ibm.psw.wcl.core.markup.WTextComponent;
import com.ibm.psw.wcl.core.resource.IResource;
import com.ibm.psw.wcl.core.resource.UrlResource;
import com.ibm.psw.wcl.core.skin.AStyleInfo;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HealthAction
implements Action {
    public static final String FRAME_NAME = "health_frame";
    public static final String FRAME_PATH = "frames['health_frame']";
    public static final String URI = "health.do";
    public static final String TITLEBAR_HEIGHT = "23px";
    public static final LocalizableText minimizeText = new LocalizableText("com/ibm/hwmca/ui/bonsai/res/text", "status.summary.minimize");
    public static final LocalizableText restoreText = new LocalizableText("com/ibm/hwmca/ui/bonsai/res/text", "status.summary.restore");
    private static final String TRACEMASKT = "XBRWACTT";
    private static final String TRACEMASKF = "XBRWACTF";
    private static final String TRACEMASKD = "XBRWACTD";

    public WPage perform(HttpServlet ctrlrServlet, HttpServletRequest request, HttpServletResponse response, RenderingContext rc) throws IOException, ServletException {
        HMCSession hmcSession = HMCSession.getHMCSession(rc.getSession());
        UserObject userObj = UserObject.getUserObject(hmcSession);
        EHealtharea eHealtharea = (EHealtharea)hmcSession.getSessionAttribute("EHealtharea");
        if (eHealtharea == null) {
            eHealtharea = new EHealtharea(rc, userObj);
            hmcSession.setSessionAttribute("EHealtharea", eHealtharea);
        }
        WPage docContainer = eHealtharea.getResourcesDocument(rc, userObj);
        return docContainer;
    }

    private class ButtonCommandListener
    implements ICommandListener {
        private ButtonCommandListener() {
        }

        public void commandPerformed(CommandEvent ce) {
            WImageButton expandCollapseImageButton = (WImageButton)ce.getSource();
            HMCSession hmcSession = HMCSession.getHMCSession(ce.getTriggerContext().getSession());
            UserObject userObj = UserObject.getUserObject(hmcSession);
            EHealtharea eHealtharea = (EHealtharea)hmcSession.getSessionAttribute("EHealtharea");
            SystemHealthModel model = eHealtharea.getModel();
            InitAction.EFrameset eFrameset = (InitAction.EFrameset)hmcSession.getSessionAttribute("EFrameset");
            WFramesetLayout navigationAreaFrameset = eFrameset.getNavAreaFrameset();
            if (model.isMaximized()) {
                expandCollapseImageButton.setAltText(restoreText.toString(ce.getTriggerContext().getLocale()));
                expandCollapseImageButton.setResource((IResource)new UrlResource("/res/com/ibm/hwmca/ui/bonsai/images/restore_light.gif"));
                expandCollapseImageButton.setDirty(true);
                model.setMaximized(false);
                String[] rows = navigationAreaFrameset.getRows();
                rows[0] = "*";
                rows[1] = HealthAction.TITLEBAR_HEIGHT;
                navigationAreaFrameset.setRows(rows);
                UIRefreshManager.resizeFrame(hmcSession, "BonsaiNavigationFramesetID", "*,23px");
                UIRefreshManager.refresh(6, userObj.getHMCSession());
            } else {
                expandCollapseImageButton.setAltText(minimizeText.toString(ce.getTriggerContext().getLocale()));
                expandCollapseImageButton.setResource((IResource)new UrlResource("/res/com/ibm/hwmca/ui/bonsai/images/minimize_light.gif"));
                expandCollapseImageButton.setDirty(true);
                model.setMaximized(true);
                String[] rows = navigationAreaFrameset.getRows();
                rows[0] = "70%";
                rows[1] = "*";
                navigationAreaFrameset.setRows(rows);
                UIRefreshManager.resizeFrame(hmcSession, "BonsaiNavigationFramesetID", "70%,*");
                UIRefreshManager.refresh(6, userObj.getHMCSession());
            }
        }
    }

    private class EHealtharea
    implements Serializable {
        private WccTitlebar titlebar_ = null;
        private WBoxLayout titleLayout_ = null;
        private WBoxLayout monitorLayout_ = null;
        private UserObject userObj = null;
        private static final String MODEL_VISIBILITY_KEY = "com.ibm.hwmca.ui.bonsai.servlet.HealthAction";
        private WPage docContainer_ = null;
        private WImage statusImage_ = null;
        private WImageButton expandCollapseImageButton_ = null;
        private SystemHealthModel model_ = null;
        final String greenGradient = "/res/com/ibm/hwmca/ui/bonsai/images/fin_green_best.gif";
        final String redGradient = "/res/com/ibm/hwmca/ui/bonsai/images/fin_red_grad.gif";
        final String redAccent = "#c00";
        final String greenAccent = "#363";
        final String greenIcon = "/res/com/ibm/hwmca/ui/bonsai/images/normal_greenwhite.gif";
        final String redIcon = "/res/com/ibm/hwmca/ui/bonsai/images/error_redwhite.gif";
        final String redShade_ = "fee";
        final String greenShade_ = "#f2fff2";
        private String titleStatusIcon_ = null;
        private String shadeColor_ = null;
        private String titlegradient_ = null;
        private String titleborderAccent_ = null;
        LocalizableText titleText = new LocalizableText("com/ibm/hwmca/ui/bonsai/res/text", "status.summary.title");
        final String leftIconImagePadding = "10px";

        public EHealtharea(RenderingContext rc, UserObject userObj) {
            this.model_ = new SystemHealthModel(MODEL_VISIBILITY_KEY, userObj);
            StatusMonitorManager statusManager = userObj.getStatusMonitorManager();
            statusManager.addStatusMonitorPropertyListener(this.model_);
            statusManager.getEventQueue().addEventQueueListener(this.model_);
            userObj.setModelVisible(HealthAction.URI, MODEL_VISIBILITY_KEY);
            this.statusImage_ = new WImage();
            this.statusImage_.setBorder("0");
            this.docContainer_ = new WPage("HealthActionPage");
            this.docContainer_.setID("HealthActionPageID");
            AStyleInfo pageStyle = this.docContainer_.getStyleInfo(rc.getSkin());
            pageStyle.setStyleValue("page1", "margin", (Object)"0px 0px 0px 0px");
            pageStyle.setStyleValue("page1", "padding", (Object)"0px 0px 0px 0px");
            this.docContainer_.setStyleInfo(pageStyle);
            this.expandCollapseImageButton_ = new WImageButton();
            this.expandCollapseImageButton_.setAlign("middle");
            this.expandCollapseImageButton_.addCommandListener((ICommandListener)new ButtonCommandListener());
            WTextComponent text = new WTextComponent(this.titleText.toString(rc.getLocale()));
            AStyleInfo textStyle = text.getStyleInfo(rc.getSkin());
            textStyle.setStyleValue("txt", "color", (Object)"fff");
            textStyle.setStyleValue("txt", "font-family", (Object)"Arial, Helvetica, sans-serif");
            textStyle.setStyleValue("txt", "color", (Object)"fff");
            textStyle.setStyleValue("txt", "font-size", (Object)"smaller");
            textStyle.setStyleValue("txt", "font-weight", (Object)"bold");
            this.titleLayout_ = new WBoxLayout("horizontal");
            this.titleLayout_.setAlignment((WComponent)text, "left");
            WBoxLayout innerLayout = new WBoxLayout("horizontal");
            AStyleInfo titleLayoutStyle = innerLayout.getStyleInfo(rc.getSkin());
            titleLayoutStyle.setStyleValue("lyt2", "padding-left", (Object)"10px");
            innerLayout.setStyleInfo(titleLayoutStyle);
            innerLayout.add((WComponent)this.statusImage_);
            innerLayout.add((WComponent)text);
            innerLayout.setWidth(null);
            innerLayout.setAlignment((WComponent)this.statusImage_, "left");
            innerLayout.setAlignment((WComponent)text, "left");
            this.titleLayout_.add((WComponent)innerLayout);
            this.titleLayout_.add((WComponent)this.expandCollapseImageButton_);
            this.titleLayout_.setAlignment((WComponent)this.expandCollapseImageButton_, "right");
            this.titleLayout_.setWidth("100%");
            this.docContainer_.add((WComponent)this.titleLayout_);
            this.monitorLayout_ = new WBoxLayout("vertical");
            this.monitorLayout_.setGap(5);
            this.monitorLayout_.setWidth(null);
            this.docContainer_.add((WComponent)this.monitorLayout_);
        }

        public WPage getResourcesDocument(RenderingContext rc, UserObject userObj) throws IOException, ServletException {
            Trace.trace(HealthAction.TRACEMASKT, "-> EHealtharea.getResourcesDocument()");
            try {
                if (this.isUnacceptableStatus()) {
                    this.titleStatusIcon_ = "/res/com/ibm/hwmca/ui/bonsai/images/error_redwhite.gif";
                    this.titlegradient_ = "/res/com/ibm/hwmca/ui/bonsai/images/fin_red_grad.gif";
                    this.titleborderAccent_ = "#c00";
                    this.shadeColor_ = "fee";
                } else {
                    this.titleStatusIcon_ = "/res/com/ibm/hwmca/ui/bonsai/images/normal_greenwhite.gif";
                    this.titlegradient_ = "/res/com/ibm/hwmca/ui/bonsai/images/fin_green_best.gif";
                    this.titleborderAccent_ = "#c00";
                    this.shadeColor_ = "#f2fff2";
                }
                AStyleInfo pageStyle = this.docContainer_.getStyleInfo(rc.getSkin());
                pageStyle.setStyleValue("page1", "background-color", (Object)this.shadeColor_);
                this.docContainer_.setStyleInfo(pageStyle);
                this.updateTitleBar(rc, userObj);
                this.buildMonitorData(rc);
            }
            catch (Exception ex) {
                throw new ServletException("Error creating WccToolbar and contained objects in ETaskbarResources.", (Throwable)ex);
            }
            Trace.trace(HealthAction.TRACEMASKT, "<- ETaskbarResources.createResourcesDocument()");
            return this.docContainer_;
        }

        protected void updateTitleBar(RenderingContext rc, UserObject userObj) {
            AStyleInfo boxLayoutStyle = this.titleLayout_.getStyleInfo(rc.getSkin());
            boxLayoutStyle.setStyleValue("lyt1", "background-image", (Object)("url(" + this.titlegradient_ + ")"));
            boxLayoutStyle.setStyleValue("lyt1", "height", (Object)HealthAction.TITLEBAR_HEIGHT);
            this.titleLayout_.setStyleInfo(boxLayoutStyle);
            this.statusImage_.setURL(this.titleStatusIcon_);
            this.expandCollapseImageButton_.setTitle("toggle button");
            if (this.model_.isMaximized()) {
                this.expandCollapseImageButton_.setAltText("Minimize");
                this.expandCollapseImageButton_.setResource((IResource)new UrlResource("/res/com/ibm/hwmca/ui/bonsai/images/minimize_light.gif"));
            } else {
                this.expandCollapseImageButton_.setResource((IResource)new UrlResource("/res/com/ibm/hwmca/ui/bonsai/images/restore_light.gif"));
            }
        }

        protected void buildMonitorData(RenderingContext rc) {
            AStyleInfo boxLayoutStyle = this.monitorLayout_.getStyleInfo(rc.getSkin());
            boxLayoutStyle.setStyleValue("lyt1", "padding", (Object)"20px 0px 0px 10px");
            this.monitorLayout_.setStyleInfo(boxLayoutStyle);
            this.monitorLayout_.removeAll();
            Iterator i = this.model_.getBeans().iterator();
            while (i.hasNext()) {
                StatusMonitorBean bean = (StatusMonitorBean)i.next();
                String url = bean.getUrl();
                String urlTarget = bean.getUrlTarget();
                WBoxLayout statusBoxLayout = new WBoxLayout("horizontal");
                statusBoxLayout.setWidth(null);
                statusBoxLayout.setGap(5);
                WImageButton imageButton = new WImageButton();
                imageButton.setURL(bean.getStatusImage());
                imageButton.setAltText(bean.getCaption());
                if (url != null) {
                    imageButton.setLinkUrl(url);
                    imageButton.setLinkTarget(urlTarget);
                } else {
                    imageButton.setEnabled(false);
                }
                statusBoxLayout.add((WComponent)imageButton);
                statusBoxLayout.setAlignment((WComponent)imageButton, "left");
                if (url != null) {
                    WHyperlink hyperlink = new WHyperlink();
                    hyperlink.setURL(url);
                    hyperlink.setTarget(urlTarget);
                    hyperlink.setText(bean.getName());
                    AStyleInfo hyperlinkStyle = hyperlink.getStyleInfo(rc.getSkin());
                    hyperlinkStyle.setStyleValue("lnk1", "font-size", (Object)"smaller");
                    hyperlink.setStyleInfo(hyperlinkStyle);
                    statusBoxLayout.add((WComponent)hyperlink);
                    statusBoxLayout.setAlignment((WComponent)hyperlink, "left");
                } else {
                    WTextComponent text = new WTextComponent(bean.getName());
                    AStyleInfo textStyle = text.getStyleInfo(rc.getSkin());
                    textStyle.setStyleValue("txt", "font-size", (Object)"smaller");
                    text.setStyleInfo(textStyle);
                    statusBoxLayout.add((WComponent)text);
                    statusBoxLayout.setAlignment((WComponent)text, "left");
                }
                this.monitorLayout_.add((WComponent)statusBoxLayout);
            }
        }

        protected boolean isUnacceptableStatus() {
            StatusMonitorBean bean = null;
            Iterator i = this.model_.getBeans().iterator();
            while (i.hasNext()) {
                bean = (StatusMonitorBean)i.next();
                if (bean.isStatusAcceptable()) continue;
                return true;
            }
            return false;
        }

        protected void finalize() {
            StatusMonitorManager statusManager = this.userObj.getStatusMonitorManager();
            statusManager.removeStatusMonitorPropertyListener(this.model_);
            statusManager.getEventQueue().removeEventQueueListener(this.model_);
        }

        public SystemHealthModel getModel() {
            return this.model_;
        }
    }
}

